/*!
 * @file        bsp_usart.h
 *
 * @brief       Header for bsp_usart.c module
 *
 * @version     V1.0.0
 *
 * @date        2022-02-25
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

#ifndef __BSP_USART_H
#define __BSP_USART_H

#ifdef __cplusplus
  extern "C" {
#endif

#include "Board.h"
#include "bsp_delay.h"

#define USART1_REV_LEN          200

#if defined (APM32F407_MINI)
#define APM_COMInit     APM_MINI_COMInit
#define UART_COM1       MINI_COM1
#define UART_COM1_IRQn  MINI_COM1_IRQn
#define UART_COM2       MINI_COM2
#define UART_COM2_IRQn  MINI_COM2_IRQn

#elif defined (APM32F407_ELE_HUETB)
#define APM_COMInit     APM_ELE_HUETB_COMInit
#define UART_COM1       ELE_HUETB_COM1
#define UART_COM1_IRQn  ELE_HUETB_COM1_IRQn
#define UART_COM2       ELE_HUETB_COM2
#define UART_COM2_IRQn  ELE_HUETB_COM2_IRQn

#elif defined (APM32F407_EVAL)
#define APM_COMInit     APM_EVAL_COMInit
#define UART_COM1       EVAL_COM1
#define UART_COM1_IRQn  EVAL_COM1_IRQn
#define UART_COM2       EVAL_COM2
#define UART_COM2_IRQn  EVAL_COM2_IRQn

#else
#error "Please select first the APM32 board to be used (in board.c)"
#endif

/*!
 * @brief    USART receive status structure
 */
typedef struct
{
    union
    {
        uint16_t USART_RX_STA;

        struct
        {
            uint16_t VALID_LENGHT                   :14;    //!< The lenght of valid data
            uint16_t FLAG_FRAME_BREAK               :1;     //!< Data frame break flag
            uint16_t FLAG_FRAME_END                 :1;     //!< Data frame end flag
        }USART_RX_STA_B;
    };
}USART_RX_STA_T;

/** extern variables*/
extern u8 rxBufUSART1[USART1_REV_LEN];
extern USART_RX_STA_T rxStaUSART1;

/** function declaration*/
void USART1_Init(uint32_t baud);
void USART2_Init(uint32_t baud);
void USART_Write(USART_T* usart,uint8_t *dat, uint32_t count);
void USART_Receive_Isr(void);

#ifdef __cplusplus
}
#endif

#endif
